/*!
 * typeahead.js 0.11.1
 * https://github.com/twitter/typeahead.js
 * Copyright 2013-2015 Twitter, Inc. and other contributors; Licensed MIT
 */
(function(t,e){if(typeof define==="function"&&define.amd){define("typeahead.js",["jquery"],function(t){return e(t)})}else if(typeof exports==="object"){module.exports=e(require("jquery"))}else{e(jQuery)}})(this,function(t){var e=function(){"use strict";return{isMsie:function(){return/(msie|trident)/i.test(navigator.userAgent)?navigator.userAgent.match(/(msie |rv:)(\d+(.\d+)?)/i)[2]:false},isBlankString:function(t){return!t||/^\s*$/.test(t)},escapeRegExChars:function(t){return t.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")},isString:function(t){return typeof t==="string"},isNumber:function(t){return typeof t==="number"},isArray:t.isArray,isFunction:t.isFunction,isObject:t.isPlainObject,isUndefined:function(t){return typeof t==="undefined"},isElement:function(t){return!!(t&&t.nodeType===1)},isJQuery:function(e){return e instanceof t},toStr:function t(n){return e.isUndefined(n)||n===null?"":n+""},bind:t.proxy,each:function(e,n){t.each(e,i);function i(t,e){return n(e,t)}},map:t.map,filter:t.grep,every:function(e,n){var i=true;if(!e){return i}t.each(e,function(t,s){if(!(i=n.call(null,s,t,e))){return false}});return!!i},some:function(e,n){var i=false;if(!e){return i}t.each(e,function(t,s){if(i=n.call(null,s,t,e)){return false}});return!!i},mixin:t.extend,identity:function(t){return t},clone:function(e){return t.extend(true,{},e)},getIdGenerator:function(){var t=0;return function(){return t++}},templatify:function e(n){return t.isFunction(n)?n:i;function i(){return String(n)}},defer:function(t){setTimeout(t,0)},debounce:function(t,e,n){var i,s;return function(){var r=this,a=arguments,u,o;u=function(){i=null;if(!n){s=t.apply(r,a)}};o=n&&!i;clearTimeout(i);i=setTimeout(u,e);if(o){s=t.apply(r,a)}return s}},throttle:function(t,e){var n,i,s,r,a,u;a=0;u=function(){a=new Date;s=null;r=t.apply(n,i)};return function(){var o=new Date,c=e-(o-a);n=this;i=arguments;if(c<=0){clearTimeout(s);s=null;a=o;r=t.apply(n,i)}else if(!s){s=setTimeout(u,c)}return r}},stringify:function(t){return e.isString(t)?t:JSON.stringify(t)},noop:function(){}}}();var n=function(){"use strict";var t={wrapper:"twitter-typeahead",input:"tt-input",hint:"tt-hint",menu:"tt-menu",dataset:"tt-dataset",suggestion:"tt-suggestion",selectable:"tt-selectable",empty:"tt-empty",open:"tt-open",cursor:"tt-cursor",highlight:"tt-highlight"};return n;function n(n){var a,u;u=e.mixin({},t,n);a={css:r(),classes:u,html:i(u),selectors:s(u)};return{css:a.css,html:a.html,classes:a.classes,selectors:a.selectors,mixin:function(t){e.mixin(t,a)}}}function i(t){return{wrapper:'<span class="'+t.wrapper+'"></span>',menu:'<div class="'+t.menu+'"></div>'}}function s(t){var n={};e.each(t,function(t,e){n[e]="."+t});return n}function r(){var t={wrapper:{position:"relative",display:"inline-block"},hint:{position:"absolute",top:"0",left:"0",borderColor:"transparent",boxShadow:"none",opacity:"1"},input:{position:"relative",verticalAlign:"top",backgroundColor:"transparent"},inputWithNoHint:{position:"relative",verticalAlign:"top"},menu:{position:"absolute",top:"100%",left:"0",zIndex:"100",display:"none"},ltr:{left:"0",right:"auto"},rtl:{left:"auto",right:" 0"}};if(e.isMsie()){e.mixin(t.input,{backgroundImage:"url(data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7)"})}return t}}();var i=function(){"use strict";var n,i;n="typeahead:";i={render:"rendered",cursorchange:"cursorchanged",select:"selected",autocomplete:"autocompleted"};function s(e){if(!e||!e.el){t.error("EventBus initialized without el")}this.$el=t(e.el)}e.mixin(s.prototype,{_trigger:function(e,i){var s;s=t.Event(n+e);(i=i||[]).unshift(s);this.$el.trigger.apply(this.$el,i);return s},before:function(t){var e,n;e=[].slice.call(arguments,1);n=this._trigger("before"+t,e);return n.isDefaultPrevented()},trigger:function(t){var e;this._trigger(t,[].slice.call(arguments,1));if(e=i[t]){this._trigger(e,[].slice.call(arguments,1))}}});return s}();var s=function(){"use strict";var t=/\s+/,e=o();return{onSync:s,onAsync:i,off:r,trigger:a};function n(e,n,i,s){var r;if(!i){return this}n=n.split(t);i=s?c(i,s):i;this._callbacks=this._callbacks||{};while(r=n.shift()){this._callbacks[r]=this._callbacks[r]||{sync:[],async:[]};this._callbacks[r][e].push(i)}return this}function i(t,e,i){return n.call(this,"async",t,e,i)}function s(t,e,i){return n.call(this,"sync",t,e,i)}function r(e){var n;if(!this._callbacks){return this}e=e.split(t);while(n=e.shift()){delete this._callbacks[n]}return this}function a(n){var i,s,r,a,o;if(!this._callbacks){return this}n=n.split(t);r=[].slice.call(arguments,1);while((i=n.shift())&&(s=this._callbacks[i])){a=u(s.sync,this,[i].concat(r));o=u(s.async,this,[i].concat(r));a()&&e(o)}return this}function u(t,e,n){return i;function i(){var i;for(var s=0,r=t.length;!i&&s<r;s+=1){i=t[s].apply(e,n)===false}return!i}}function o(){var t;if(window.setImmediate){t=function t(e){setImmediate(function(){e()})}}else{t=function t(e){setTimeout(function(){e()},0)}}return t}function c(t,e){return t.bind?t.bind(e):function(){t.apply(e,[].slice.call(arguments,0))}}}();var r=function(t){"use strict";var n={node:null,pattern:null,tagName:"strong",className:null,wordsOnly:false,caseSensitive:false};return function s(r){var a;r=e.mixin({},n,r);if(!r.node||!r.pattern){return}r.pattern=e.isArray(r.pattern)?r.pattern:[r.pattern];a=i(r.pattern,r.caseSensitive,r.wordsOnly);o(r.node,u);function u(e){var n,i,s;if(n=a.exec(e.data)){s=t.createElement(r.tagName);r.className&&(s.className=r.className);i=e.splitText(n.index);i.splitText(n[0].length);s.appendChild(i.cloneNode(true));e.parentNode.replaceChild(s,i)}return!!n}function o(t,e){var n,i=3;for(var s=0;s<t.childNodes.length;s++){n=t.childNodes[s];if(n.nodeType===i){s+=e(n)?1:0}else{o(n,e)}}}};function i(t,n,i){var s=[],r;for(var a=0,u=t.length;a<u;a++){s.push(e.escapeRegExChars(t[a]))}r=i?"\\b("+s.join("|")+")\\b":"("+s.join("|")+")";return n?new RegExp(r):new RegExp(r,"i")}}(window.document);var a=function(){"use strict";var n;n={9:"tab",27:"esc",37:"left",39:"right",13:"enter",38:"up",40:"down"};function i(n,i){n=n||{};if(!n.input){t.error("input is missing")}i.mixin(this);this.$hint=t(n.hint);this.$input=t(n.input);this.query=this.$input.val();this.queryWhenFocused=this.hasFocus()?this.query:null;this.$overflowHelper=r(this.$input);this._checkLanguageDirection();if(this.$hint.length===0){this.setHint=this.getHint=this.clearHint=this.clearHintIfInvalid=e.noop}}i.normalizeQuery=function(t){return e.toStr(t).replace(/^\s*/g,"").replace(/\s{2,}/g," ")};e.mixin(i.prototype,s,{_onBlur:function t(){this.resetInputValue();this.trigger("blurred")},_onFocus:function t(){this.queryWhenFocused=this.query;this.trigger("focused")},_onKeydown:function t(e){var i=n[e.which||e.keyCode];this._managePreventDefault(i,e);if(i&&this._shouldTrigger(i,e)){this.trigger(i+"Keyed",e)}},_onInput:function t(){this._setQuery(this.getInputValue());this.clearHintIfInvalid();this._checkLanguageDirection()},_managePreventDefault:function t(e,n){var i;switch(e){case"up":case"down":i=!u(n);break;default:i=false}i&&n.preventDefault()},_shouldTrigger:function t(e,n){var i;switch(e){case"tab":i=!u(n);break;default:i=true}return i},_checkLanguageDirection:function t(){var e=(this.$input.css("direction")||"ltr").toLowerCase();if(this.dir!==e){this.dir=e;this.$hint.attr("dir",e);this.trigger("langDirChanged",e)}},_setQuery:function t(e,n){var i,s;i=a(e,this.query);s=i?this.query.length!==e.length:false;this.query=e;if(!n&&!i){this.trigger("queryChanged",this.query)}else if(!n&&s){this.trigger("whitespaceChanged",this.query)}},bind:function(){var t=this,i,s,r,a;i=e.bind(this._onBlur,this);s=e.bind(this._onFocus,this);r=e.bind(this._onKeydown,this);a=e.bind(this._onInput,this);this.$input.on("blur.tt",i).on("focus.tt",s).on("keydown.tt",r);if(!e.isMsie()||e.isMsie()>9){this.$input.on("input.tt",a)}else{this.$input.on("keydown.tt keypress.tt cut.tt paste.tt",function(i){if(n[i.which||i.keyCode]){return}e.defer(e.bind(t._onInput,t,i))})}return this},focus:function t(){this.$input.focus()},blur:function t(){this.$input.blur()},getLangDir:function t(){return this.dir},getQuery:function t(){return this.query||""},setQuery:function t(e,n){this.setInputValue(e);this._setQuery(e,n)},hasQueryChangedSinceLastFocus:function t(){return this.query!==this.queryWhenFocused},getInputValue:function t(){return this.$input.val()},setInputValue:function t(e){this.$input.val(e);this.clearHintIfInvalid();this._checkLanguageDirection()},resetInputValue:function t(){this.setInputValue(this.query)},getHint:function t(){return this.$hint.val()},setHint:function t(e){this.$hint.val(e)},clearHint:function t(){this.setHint("")},clearHintIfInvalid:function t(){var e,n,i,s;e=this.getInputValue();n=this.getHint();i=e!==n&&n.indexOf(e)===0;s=e!==""&&i&&!this.hasOverflow();!s&&this.clearHint()},hasFocus:function t(){return this.$input.is(":focus")},hasOverflow:function t(){var e=this.$input.width()-2;this.$overflowHelper.text(this.getInputValue());return this.$overflowHelper.width()>=e},isCursorAtEnd:function(){var t,n,i;t=this.$input.val().length;n=this.$input[0].selectionStart;if(e.isNumber(n)){return n===t}else if(document.selection){i=document.selection.createRange();i.moveStart("character",-t);return t===i.text.length}return true},destroy:function e(){this.$hint.off(".tt");this.$input.off(".tt");this.$overflowHelper.remove();this.$hint=this.$input=this.$overflowHelper=t("<div>")}});return i;function r(e){return t('<pre aria-hidden="true"></pre>').css({position:"absolute",visibility:"hidden",whiteSpace:"pre",fontFamily:e.css("font-family"),fontSize:e.css("font-size"),fontStyle:e.css("font-style"),fontVariant:e.css("font-variant"),fontWeight:e.css("font-weight"),wordSpacing:e.css("word-spacing"),letterSpacing:e.css("letter-spacing"),textIndent:e.css("text-indent"),textRendering:e.css("text-rendering"),textTransform:e.css("text-transform")}).insertAfter(e)}function a(t,e){return i.normalizeQuery(t)===i.normalizeQuery(e)}function u(t){return t.altKey||t.ctrlKey||t.metaKey||t.shiftKey}}();var u=function(){"use strict";var n,i;n={val:"tt-selectable-display",obj:"tt-selectable-object"};i=e.getIdGenerator();function a(n,s){n=n||{};n.templates=n.templates||{};n.templates.notFound=n.templates.notFound||n.templates.empty;if(!n.source){t.error("missing source")}if(!n.node){t.error("missing node")}if(n.name&&!c(n.name)){t.error("invalid dataset name: "+n.name)}s.mixin(this);this.highlight=!!n.highlight;this.name=n.name||i();this.limit=n.limit||5;this.displayFn=u(n.display||n.displayKey);this.templates=o(n.templates,this.displayFn);this.source=n.source.__ttAdapter?n.source.__ttAdapter():n.source;this.async=e.isUndefined(n.async)?this.source.length>2:!!n.async;this._resetLastSuggestion();this.$el=t(n.node).addClass(this.classes.dataset).addClass(this.classes.dataset+"-"+this.name)}a.extractData=function e(i){var s=t(i);if(s.data(n.obj)){return{val:s.data(n.val)||"",obj:s.data(n.obj)||null}}return null};e.mixin(a.prototype,s,{_overwrite:function t(e,n){n=n||[];if(n.length){this._renderSuggestions(e,n)}else if(this.async&&this.templates.pending){this._renderPending(e)}else if(!this.async&&this.templates.notFound){this._renderNotFound(e)}else{this._empty()}this.trigger("rendered",this.name,n,false)},_append:function t(e,n){n=n||[];if(n.length&&this.$lastSuggestion.length){this._appendSuggestions(e,n)}else if(n.length){this._renderSuggestions(e,n)}else if(!this.$lastSuggestion.length&&this.templates.notFound){this._renderNotFound(e)}this.trigger("rendered",this.name,n,true)},_renderSuggestions:function t(e,n){var i;i=this._getSuggestionsFragment(e,n);this.$lastSuggestion=i.children().last();this.$el.html(i).prepend(this._getHeader(e,n)).append(this._getFooter(e,n))},_appendSuggestions:function t(e,n){var i,s;i=this._getSuggestionsFragment(e,n);s=i.children().last();this.$lastSuggestion.after(i);this.$lastSuggestion=s},_renderPending:function t(e){var n=this.templates.pending;this._resetLastSuggestion();n&&this.$el.html(n({query:e,dataset:this.name}))},_renderNotFound:function t(e){var n=this.templates.notFound;this._resetLastSuggestion();n&&this.$el.html(n({query:e,dataset:this.name}))},_empty:function t(){this.$el.empty();this._resetLastSuggestion()},_getSuggestionsFragment:function i(s,a){var u=this,o;o=document.createDocumentFragment();e.each(a,function e(i){var r,a;a=u._injectQuery(s,i);r=t(u.templates.suggestion(a)).data(n.obj,i).data(n.val,u.displayFn(i)).addClass(u.classes.suggestion+" "+u.classes.selectable);o.appendChild(r[0])});this.highlight&&r({className:this.classes.highlight,node:o,pattern:s});return t(o)},_getFooter:function t(e,n){return this.templates.footer?this.templates.footer({query:e,suggestions:n,dataset:this.name}):null},_getHeader:function t(e,n){return this.templates.header?this.templates.header({query:e,suggestions:n,dataset:this.name}):null},_resetLastSuggestion:function e(){this.$lastSuggestion=t()},_injectQuery:function t(n,i){return e.isObject(i)?e.mixin({_query:n},i):i},update:function e(n){var i=this,s=false,r=false,a=0;this.cancel();this.cancel=function e(){s=true;i.cancel=t.noop;i.async&&i.trigger("asyncCanceled",n)};this.source(n,u,o);!r&&u([]);function u(t){if(r){return}r=true;t=(t||[]).slice(0,i.limit);a=t.length;i._overwrite(n,t);if(a<i.limit&&i.async){i.trigger("asyncRequested",n)}}function o(e){e=e||[];if(!s&&a<i.limit){i.cancel=t.noop;i._append(n,e.slice(0,i.limit-a));a+=e.length;i.async&&i.trigger("asyncReceived",n)}}},cancel:t.noop,clear:function t(){this._empty();this.cancel();this.trigger("cleared")},isEmpty:function t(){return this.$el.is(":empty")},destroy:function e(){this.$el=t("<div>")}});return a;function u(t){t=t||e.stringify;return e.isFunction(t)?t:n;function n(e){return e[t]}}function o(n,i){return{notFound:n.notFound&&e.templatify(n.notFound),pending:n.pending&&e.templatify(n.pending),header:n.header&&e.templatify(n.header),footer:n.footer&&e.templatify(n.footer),suggestion:n.suggestion||s};function s(e){return t("<div>").text(i(e))}}function c(t){return/^[_a-zA-Z0-9-]+$/.test(t)}}();var o=function(){"use strict";function n(n,i){var s=this;n=n||{};if(!n.node){t.error("node is required")}i.mixin(this);this.$node=t(n.node);this.query=null;this.datasets=e.map(n.datasets,r);function r(e){var n=s.$node.find(e.node).first();e.node=n.length?n:t("<div>").appendTo(s.$node);return new u(e,i)}}e.mixin(n.prototype,s,{_onSelectableClick:function e(n){this.trigger("selectableClicked",t(n.currentTarget))},_onRendered:function t(e,n,i,s){this.$node.toggleClass(this.classes.empty,this._allDatasetsEmpty());this.trigger("datasetRendered",n,i,s)},_onCleared:function t(){this.$node.toggleClass(this.classes.empty,this._allDatasetsEmpty());this.trigger("datasetCleared")},_propagate:function t(){this.trigger.apply(this,arguments)},_allDatasetsEmpty:function t(){return e.every(this.datasets,n);function n(t){return t.isEmpty()}},_getSelectables:function t(){return this.$node.find(this.selectors.selectable)},_removeCursor:function t(){var e=this.getActiveSelectable();e&&e.removeClass(this.classes.cursor)},_ensureVisible:function t(e){var n,i,s,r;n=e.position().top;i=n+e.outerHeight(true);s=this.$node.scrollTop();r=this.$node.height()+parseInt(this.$node.css("paddingTop"),10)+parseInt(this.$node.css("paddingBottom"),10);if(n<0){this.$node.scrollTop(s+n)}else if(r<i){this.$node.scrollTop(s+(i-r))}},bind:function(){var t=this,n;n=e.bind(this._onSelectableClick,this);this.$node.on("click.tt",this.selectors.selectable,n);e.each(this.datasets,function(e){e.onSync("asyncRequested",t._propagate,t).onSync("asyncCanceled",t._propagate,t).onSync("asyncReceived",t._propagate,t).onSync("rendered",t._onRendered,t).onSync("cleared",t._onCleared,t)});return this},isOpen:function t(){return this.$node.hasClass(this.classes.open)},open:function t(){this.$node.addClass(this.classes.open)},close:function t(){this.$node.removeClass(this.classes.open);this._removeCursor()},setLanguageDirection:function t(e){this.$node.attr("dir",e)},selectableRelativeToCursor:function t(e){var n,i,s,r;i=this.getActiveSelectable();n=this._getSelectables();s=i?n.index(i):-1;r=s+e;r=(r+1)%(n.length+1)-1;r=r<-1?n.length-1:r;return r===-1?null:n.eq(r)},setCursor:function t(e){this._removeCursor();if(e=e&&e.first()){e.addClass(this.classes.cursor);this._ensureVisible(e)}},getSelectableData:function t(e){return e&&e.length?u.extractData(e):null},getActiveSelectable:function t(){var e=this._getSelectables().filter(this.selectors.cursor).first();return e.length?e:null},getTopSelectable:function t(){var e=this._getSelectables().first();return e.length?e:null},update:function t(n){var i=n!==this.query;if(i){this.query=n;e.each(this.datasets,s)}return i;function s(t){t.update(n)}},empty:function t(){e.each(this.datasets,n);this.query=null;this.$node.addClass(this.classes.empty);function n(t){t.clear()}},destroy:function n(){this.$node.off(".tt");this.$node=t("<div>");e.each(this.datasets,i);function i(t){t.destroy()}}});return n}();var c=function(){"use strict";var t=o.prototype;function n(){o.apply(this,[].slice.call(arguments,0))}e.mixin(n.prototype,o.prototype,{open:function e(){!this._allDatasetsEmpty()&&this._show();return t.open.apply(this,[].slice.call(arguments,0))},close:function e(){this._hide();return t.close.apply(this,[].slice.call(arguments,0))},_onRendered:function e(){if(this._allDatasetsEmpty()){this._hide()}else{this.isOpen()&&this._show()}return t._onRendered.apply(this,[].slice.call(arguments,0))},_onCleared:function e(){if(this._allDatasetsEmpty()){this._hide()}else{this.isOpen()&&this._show()}return t._onCleared.apply(this,[].slice.call(arguments,0))},setLanguageDirection:function e(n){this.$node.css(n==="ltr"?this.css.ltr:this.css.rtl);return t.setLanguageDirection.apply(this,[].slice.call(arguments,0))},_hide:function t(){this.$node.hide()},_show:function t(){this.$node.css("display","block")}});return n}();var l=function(){"use strict";function n(n,s){var r,a,u,o,c,l,h,f,d,p,g;n=n||{};if(!n.input){t.error("missing input")}if(!n.menu){t.error("missing menu")}if(!n.eventBus){t.error("missing event bus")}s.mixin(this);this.eventBus=n.eventBus;this.minLength=e.isNumber(n.minLength)?n.minLength:1;this.input=n.input;this.menu=n.menu;this.enabled=true;this.active=false;this.input.hasFocus()&&this.activate();this.dir=this.input.getLangDir();this._hacks();this.menu.bind().onSync("selectableClicked",this._onSelectableClicked,this).onSync("asyncRequested",this._onAsyncRequested,this).onSync("asyncCanceled",this._onAsyncCanceled,this).onSync("asyncReceived",this._onAsyncReceived,this).onSync("datasetRendered",this._onDatasetRendered,this).onSync("datasetCleared",this._onDatasetCleared,this);r=i(this,"activate","open","_onFocused");a=i(this,"deactivate","_onBlurred");u=i(this,"isActive","isOpen","_onEnterKeyed");o=i(this,"isActive","isOpen","_onTabKeyed");c=i(this,"isActive","_onEscKeyed");l=i(this,"isActive","open","_onUpKeyed");h=i(this,"isActive","open","_onDownKeyed");f=i(this,"isActive","isOpen","_onLeftKeyed");d=i(this,"isActive","isOpen","_onRightKeyed");p=i(this,"_openIfActive","_onQueryChanged");g=i(this,"_openIfActive","_onWhitespaceChanged");this.input.bind().onSync("focused",r,this).onSync("blurred",a,this).onSync("enterKeyed",u,this).onSync("tabKeyed",o,this).onSync("escKeyed",c,this).onSync("upKeyed",l,this).onSync("downKeyed",h,this).onSync("leftKeyed",f,this).onSync("rightKeyed",d,this).onSync("queryChanged",p,this).onSync("whitespaceChanged",g,this).onSync("langDirChanged",this._onLangDirChanged,this)}e.mixin(n.prototype,{_hacks:function n(){var i,s;i=this.input.$input||t("<div>");s=this.menu.$node||t("<div>");i.on("blur.tt",function(t){var n,r,a;n=document.activeElement;r=s.is(n);a=s.has(n).length>0;if(e.isMsie()&&(r||a)){t.preventDefault();t.stopImmediatePropagation();e.defer(function(){i.focus()})}});s.on("mousedown.tt",function(t){t.preventDefault()})},_onSelectableClicked:function t(e,n){this.select(n)},_onDatasetCleared:function t(){this._updateHint()},_onDatasetRendered:function t(e,n,i,s){this._updateHint();this.eventBus.trigger("render",i,s,n)},_onAsyncRequested:function t(e,n,i){this.eventBus.trigger("asyncrequest",i,n)},_onAsyncCanceled:function t(e,n,i){this.eventBus.trigger("asynccancel",i,n)},_onAsyncReceived:function t(e,n,i){this.eventBus.trigger("asyncreceive",i,n)},_onFocused:function t(){this._minLengthMet()&&this.menu.update(this.input.getQuery())},_onBlurred:function t(){if(this.input.hasQueryChangedSinceLastFocus()){this.eventBus.trigger("change",this.input.getQuery())}},_onEnterKeyed:function t(e,n){var i;if(i=this.menu.getActiveSelectable()){this.select(i)&&n.preventDefault()}},_onTabKeyed:function t(e,n){var i;if(i=this.menu.getActiveSelectable()){this.select(i)&&n.preventDefault()}else if(i=this.menu.getTopSelectable()){this.autocomplete(i)&&n.preventDefault()}},_onEscKeyed:function t(){this.close()},_onUpKeyed:function t(){this.moveCursor(-1)},_onDownKeyed:function t(){this.moveCursor(+1)},_onLeftKeyed:function t(){if(this.dir==="rtl"&&this.input.isCursorAtEnd()){this.autocomplete(this.menu.getTopSelectable())}},_onRightKeyed:function t(){if(this.dir==="ltr"&&this.input.isCursorAtEnd()){this.autocomplete(this.menu.getTopSelectable())}},_onQueryChanged:function t(e,n){this._minLengthMet(n)?this.menu.update(n):this.menu.empty()},_onWhitespaceChanged:function t(){this._updateHint()},_onLangDirChanged:function t(e,n){if(this.dir!==n){this.dir=n;this.menu.setLanguageDirection(n)}},_openIfActive:function t(){this.isActive()&&this.open()},_minLengthMet:function t(n){n=e.isString(n)?n:this.input.getQuery()||"";return n.length>=this.minLength},_updateHint:function t(){var n,i,s,r,u,o,c;n=this.menu.getTopSelectable();i=this.menu.getSelectableData(n);s=this.input.getInputValue();if(i&&!e.isBlankString(s)&&!this.input.hasOverflow()){r=a.normalizeQuery(s);u=e.escapeRegExChars(r);o=new RegExp("^(?:"+u+")(.+$)","i");c=o.exec(i.val);c&&this.input.setHint(s+c[1])}else{this.input.clearHint()}},isEnabled:function t(){return this.enabled},enable:function t(){this.enabled=true},disable:function t(){this.enabled=false},isActive:function t(){return this.active},activate:function t(){if(this.isActive()){return true}else if(!this.isEnabled()||this.eventBus.before("active")){return false}else{this.active=true;this.eventBus.trigger("active");return true}},deactivate:function t(){if(!this.isActive()){return true}else if(this.eventBus.before("idle")){return false}else{this.active=false;this.close();this.eventBus.trigger("idle");return true}},isOpen:function t(){return this.menu.isOpen()},open:function t(){if(!this.isOpen()&&!this.eventBus.before("open")){this.menu.open();this._updateHint();this.eventBus.trigger("open")}return this.isOpen()},close:function t(){if(this.isOpen()&&!this.eventBus.before("close")){this.menu.close();this.input.clearHint();this.input.resetInputValue();this.eventBus.trigger("close")}return!this.isOpen()},setVal:function t(n){this.input.setQuery(e.toStr(n))},getVal:function t(){return this.input.getQuery()},select:function t(e){var n=this.menu.getSelectableData(e);if(n&&!this.eventBus.before("select",n.obj)){this.input.setQuery(n.val,true);this.eventBus.trigger("select",n.obj);this.close();return true}return false},autocomplete:function t(e){var n,i,s;n=this.input.getQuery();i=this.menu.getSelectableData(e);s=i&&n!==i.val;if(s&&!this.eventBus.before("autocomplete",i.obj)){this.input.setQuery(i.val);this.eventBus.trigger("autocomplete",i.obj);return true}return false},moveCursor:function t(e){var n,i,s,r,a;n=this.input.getQuery();i=this.menu.selectableRelativeToCursor(e);s=this.menu.getSelectableData(i);r=s?s.obj:null;a=this._minLengthMet()&&this.menu.update(n);if(!a&&!this.eventBus.before("cursorchange",r)){this.menu.setCursor(i);if(s){this.input.setInputValue(s.val)}else{this.input.resetInputValue();this._updateHint()}this.eventBus.trigger("cursorchange",r);return true}return false},destroy:function t(){this.input.destroy();this.menu.destroy()}});return n;function i(t){var n=[].slice.call(arguments,1);return function(){var i=[].slice.call(arguments);e.each(n,function(e){return t[e].apply(t,i)})}}}();(function(){"use strict";var s,r,u;s=t.fn.typeahead;r={www:"tt-www",attrs:"tt-attrs",typeahead:"tt-typeahead"};u={initialize:function s(u,h){var p;h=e.isArray(h)?h:[].slice.call(arguments,1);u=u||{};p=n(u.classNames);return this.each(g);function g(){var n,s,g,v,m,_,b,S,w,A,C;e.each(h,function(t){t.highlight=!!u.highlight});n=t(this);s=t(p.html.wrapper);g=y(u.hint);v=y(u.menu);m=u.hint!==false&&!g;_=u.menu!==false&&!v;m&&(g=f(n,p));_&&(v=t(p.html.menu).css(p.css.menu));g&&g.val("");n=d(n,p);if(m||_){s.css(p.css.wrapper);n.css(m?p.css.input:p.css.inputWithNoHint);n.wrap(s).parent().prepend(m?g:null).append(_?v:null)}C=_?c:o;b=new i({el:n});S=new a({hint:g,input:n},p);w=new C({node:v,datasets:h},p);A=new l({input:S,menu:w,eventBus:b,minLength:u.minLength},p);n.data(r.www,p);n.data(r.typeahead,A)}},isEnabled:function t(){var e;h(this.first(),function(t){e=t.isEnabled()});return e},enable:function t(){h(this,function(t){t.enable()});return this},disable:function t(){h(this,function(t){t.disable()});return this},isActive:function t(){var e;h(this.first(),function(t){e=t.isActive()});return e},activate:function t(){h(this,function(t){t.activate()});return this},deactivate:function t(){h(this,function(t){t.deactivate()});return this},isOpen:function t(){var e;h(this.first(),function(t){e=t.isOpen()});return e},open:function t(){h(this,function(t){t.open()});return this},close:function t(){h(this,function(t){t.close()});return this},select:function e(n){var i=false,s=t(n);h(this.first(),function(t){i=t.select(s)});return i},autocomplete:function e(n){var i=false,s=t(n);h(this.first(),function(t){i=t.autocomplete(s)});return i},moveCursor:function t(e){var n=false;h(this.first(),function(t){n=t.moveCursor(e)});return n},val:function t(e){var n;if(!arguments.length){h(this.first(),function(t){n=t.getVal()});return n}else{h(this,function(t){t.setVal(e)});return this}},destroy:function t(){h(this,function(t,e){g(e);t.destroy()});return this}};t.fn.typeahead=function(t){if(u[t]){return u[t].apply(this,[].slice.call(arguments,1))}else{return u.initialize.apply(this,arguments)}};t.fn.typeahead.noConflict=function e(){t.fn.typeahead=s;return this};function h(e,n){e.each(function(){var e=t(this),i;(i=e.data(r.typeahead))&&n(i,e)})}function f(t,e){return t.clone().addClass(e.classes.hint).removeData().css(e.css.hint).css(p(t)).prop("readonly",true).removeAttr("id name placeholder required").attr({autocomplete:"off",spellcheck:"false",tabindex:-1})}function d(t,e){t.data(r.attrs,{dir:t.attr("dir"),autocomplete:t.attr("autocomplete"),spellcheck:t.attr("spellcheck"),style:t.attr("style")});t.addClass(e.classes.input).attr({autocomplete:"off",spellcheck:false});try{!t.attr("dir")&&t.attr("dir","auto")}catch(t){}return t}function p(t){return{backgroundAttachment:t.css("background-attachment"),backgroundClip:t.css("background-clip"),backgroundColor:t.css("background-color"),backgroundImage:t.css("background-image"),backgroundOrigin:t.css("background-origin"),backgroundPosition:t.css("background-position"),backgroundRepeat:t.css("background-repeat"),backgroundSize:t.css("background-size")}}function g(t){var n,i;n=t.data(r.www);i=t.parent().filter(n.selectors.wrapper);e.each(t.data(r.attrs),function(n,i){e.isUndefined(n)?t.removeAttr(i):t.attr(i,n)});t.removeData(r.typeahead).removeData(r.www).removeData(r.attr).removeClass(n.classes.input);if(i.length){t.detach().insertAfter(i);i.remove()}}function y(n){var i,s;i=e.isJQuery(n)||e.isElement(n);s=i?t(n).first():[];return s.length?s:null}})()});