<?php
session_start();
require_once('../Connections/ebanking.php');

if (isset($_GET['transferstatus']) && $_GET['transferstatus'] == '2') {
    header('Location:failedtransfer.php');
    exit;
}

// Sanitize input values
$transfertype = $_POST['transfertype'] ?? '';
$beneficiaryname = $_POST['beneficiaryname'] ?? '';
$bankname = $_POST['bankname'] ?? '';
$bankaddress = $_POST['bankaddress'] ?? '';
$Country = $_POST['Country'] ?? '';
$swiftcode = $_POST['swiftcode'] ?? '';
$iban = $_POST['iban'] ?? '';
$beneficiaryacctno = $_POST['beneficiaryacctno'] ?? '';
$amount = $_POST['amount'] ?? '';
$currency = $_POST['currency'] ?? '';
$accounttodebit = $_POST['accounttodebit'] ?? '';
$accountno = $_POST['accountno'] ?? '';

// Restrict access
$MM_restrictGoTo = "login.php";
if (!isset($_SESSION['MM_Username'])) {
    header("Location: $MM_restrictGoTo");
    exit;
}

$colname_account = mysqli_real_escape_string($ebanking, $_SESSION['MM_Username']);
$query_account = "SELECT * FROM balance WHERE account = '$colname_account'";
$account = mysqli_query($ebanking, $query_account);
$row_account = mysqli_fetch_assoc($account);

$query_trstatus = "SELECT * FROM customer WHERE transferstatus = '$colname_account'";
$trstatus = mysqli_query($ebanking, $query_trstatus);
$row_trstatus = mysqli_fetch_assoc($trstatus);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Finch Capital Credit Union - Transfer Alert</title>
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <script src="../js/jquery-3.3.1.js"></script>
    <script src="../js/bootstrap.js"></script>
    <style>
        body { background-color: #f8d7da; color: #721c24; text-align: center; }
        .alert-box { padding: 20px; margin-top: 50px; border: 2px solid red; background-color: #f8d7da; }
    </style>
</head>
<body>
    <div class="container">
        <div class="row">
            <div class="col-lg-8 col-lg-offset-2">
                <div class="alert-box">
                    <p>Your transfer has been temporarily placed on hold due to insufficient documents.</p>
                    <p>Please contact the Wire Department via wire-dept@finchcapitalcu.com</p>
                    <p><strong>⚠️Warning⚠️:</strong> Do not attempt additional transfers until the issue is resolved. We apologize for the inconvinience.</p>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
<?php
mysqli_free_result($account);
mysqli_free_result($trstatus);
?>
